# Хранилище паролей
## Основные объекты
### Общие модули
#### Внешние соединения
Имя: Д_ПСВ_ХранениеПаролей  
Тут сосредоточено 90% функционала, получение секретов, обновление серкетов из HCV, генерация токенов, всевозможное взаимодействоия итп.

### Роли
#### Основная роль
Имя: Д_ПСВ_ОсновнаяРоль  
Дает право на чтение секретов.

#### Администрирование
Имя: Д_ПСВ_Администрирование
В интерфейсе появляется подсистема, дает право на все настройки и установку секретов.

#### Чтение ключа
Имя: Д_ПСВ_ЧтениеКлюча  
Служебная, используется при работе через базу-посредний, дает право на чтение JWT ключа через HTTP сервис.

#### Установка секретов
Имя: Д_ПСВ_УстановкаСекретов  
Служебная, используется при работе через базу-посредний, дает обновить секреты в текущей базе через HTTP сервис.

### Регламентные задания
#### Получение секретов
Имя: Д_ПСВ_ПолучениеСекретов  
Получает секреты из HCV и записывает в безопасное хранилище.  
> Обновляются только те, что с галочкой **ХранениеПароляВоВнешнейСистеме**

#### Получение секретов
Имя: Д_ПСВ_ОбновитьАрендуТокена  
Обновляет токен доступа в HCV.  

### Справочники
#### Внешние соединения
Имя: Д_ПСВ_ВнешниеСоединения  
> Тут находятся данные для подключения: логины, адрес сервера итп, так же эти объекты являются владельцами секретов в безопасном хранилище.

#### Настройки соединения КХП
Имя: Д_ПСВ_НастройкиСоединенияКХП
> Тут лежат настройки подключения и протокола взаимодействия с HashiCorp Vault.

### Регистры сведений
#### Дополнительные настройки
Имя: Д_ПВС_ДополнительныеНастройки
> Служит для хранения доп настроек :)

#### Безопасное хранилище
Имя: БезопасноеХранилищеДанных
> Заимствован только для назначения прав на чтение секретов.

## Встраивание
### Подключаем расширение
- Выбрать картинку для подсистемы **Д_ПСВ_ХранениеПаролей**
- Проверить заимствование регистра сведений **БезопасноеХранилищеДанных**

### Настройка прав
Если доступ к секретам нужен **только** служебным пользователям которым назначены полные права - дополнительная настройка не требуется.

#### Общий случай
Выдать всем пользователям роль Д_ПСВ_ОсновнаяРоль, для этого ее нужно добавить в какой-то профиль назначенный всем пользователям.

> Эта роль в основном дает право только на чтение объектов, так что назначение его всем пользователям не несет угрозы, посто это может занимать длительное время.

### Заполнение настроек
Я для заполнения использую обработку [ВстраиваниеХранениеПаролей.epf](#встраивание-хранение-паролей)

#### **Константа**
**Д_ПСВ_ИмяБазы** - имя базы в продукшене.
> "ERP_USO2"

#### **Параметры подключения к HashiCorp Vault**
Пока опустим это.

#### **Дополнительные настройки**
> Не обязательно, нужно только при использовании произвольных сервисов.  

Заполнение регистра сведений Д_ПВС_ДополнительныеНастройки

#### **Настройки соединений**
Заполнение справочника Д_ПСВ_ВнешниеСоединения

### Вызовы
При любом из двух вариантв в ответ мы получил или Неопределено или структуру с четыремя полями:
- ИмяБазы
- Логин
- Секрет
- АдресСервера 
#### Стандартный сервис
``` 1C
	ИмяПубликации			= "BSO";
	ЛогинПубликации 		= "";
	ПарольПубликации 		= "";
	СерверПубликации 		= "ba.dogma.ru";
	
	Сервис = Перечисления.Д_ПСВ_Сервисы.БСО;
	ПараметрыСоединения = Д_ПСВ_ХранениеПаролей.ПолучитьПараметрыСоединения(Сервис);
	Если Не ПараметрыСоединения = Неопределено Тогда           
		ИмяПубликации 		= ПараметрыСоединения.ИмяБазы;
		ЛогинПубликации		= ПараметрыСоединения.Логин;
		ПарольПубликации 	= ПараметрыСоединения.Секрет;
		СерверПубликации 	= ПараметрыСоединения.АдресСервера;
	КонецЕсли; 
```
Нам нужно указать лишь сервис от которого требуются креды.
#### Произвольный сервис
``` 1C
	АдресСервера= "";
	Логин 		= "";
	Секрет 		= ""; 
	ИмяБазы		= "";
	
	Если Д_ПСВ_ХранениеПаролей.УстановитьТестовыйКонтур() Тогда
		Д_ВнешнееСоединение = РегистрыСведений.Д_ПВС_ДополнительныеНастройки.Сервис_dimeco_ТК();
	Иначе
		Д_ВнешнееСоединение = РегистрыСведений.Д_ПВС_ДополнительныеНастройки.Сервис_dimeco();
	КонецЕсли;
	
	ПараметрыСоединения = Д_ПСВ_ХранениеПаролей.ПолучитьПараметрыПроизвольногоСервиса(Д_ВнешнееСоединение);
	Если Не ПараметрыСоединения = Неопределено Тогда           
		АдресСервера 	= ПараметрыСоединения.АдресСервера;
		Логин 			= ПараметрыСоединения.Логин;
		Секрет 			= ПараметрыСоединения.Секрет;
		ИмяБазы 		= ПараметрыСоединения.ИмяБазы;
	КонецЕсли;  
```
Тут нужно предварительно [создать](#создание-доп-настройки) описание сервиса в регистре Дополнительные настройки, в этом примере:
- Сервис_dimeco_ТК()
- Сервис_dimeco()

## Дополнительные материалы
### Создание доп настройки
Весь функционал находится в модуле менеджера.
#### Функция СписокНастроек
Здесь содержится перечень описаний всех доп. [настроек](#описание-настройки)

#### Описание настройки
```1C
// ПарольНовогоПользователяИзДО
	ОписаниеТипа = Новый ОписаниеТипов("Строка",,,, Новый КвалификаторыСтроки("20"));
	Настройка = ОписаниеНастройки(
					"ПарольНовогоПользователяИзДО",
					ОписаниеТипа,
					"Пароль123",
					"Пароль нового пользователя создаваемого из ДО.",
					"Тут очень важный комментарий",
					Группа_Общее(),
					Истина);
	Результат.Добавить(Настройка);

```
Параметры:
1. Имя настройки - должно быть уникальным, кратко отражает смысл настройки.
2. Описание типа - возможны простые типы и любая ссылка.
3. Значение по умолчанию - допустимо вызывать другие функции.
4. Представление - имя настройки, которое будет видеть пользователь.
5. Комментарий - любые пояснения к настройке.
6. Группа - группа в которой будет отображаться настройка в форме списка.
7. Чуствительные данные - признак того, что полю нужно выставить признак Пароль (звездочки вместо данных), так же значение будет скрыто на форме списка.

### Встраивание хранение паролей
Весь код расположен в модуле формы, нас интересует две функции:
- ПриСозданииНаСервере
- ДанныеВнешнихСоединений
#### При создании на сервере
Тут нужно указать **ИмяБазыБудетУстановлено**
#### Даныне вшених соединений
Расширить взаимодействие с доп настройками.



# TODO
- добавить в модуль менеджера заполнение настроек по умолчанию
- добавить в обработку использование созданных внешних настроек из этого регистра